-- First, we declare a workspace. This is where the data will be packaged.
cfdr_workspace("cfdr_out", "FOAM-TEST")

-- Declare a table containing all the 3D models to use.
city = {
  { id = "water",      visible = true, path = "geos/water.obj",      r = 0.8, g = 0.8, b = 0.8, a = 1.0 },
  { id = "terrain",    visible = true, path = "geos/terrain.obj",    r = 0.8, g = 0.8, b = 0.8, a = 1.0 },
  { id = "roads",      visible = true, path = "geos/roads.obj",      r = 0.8, g = 0.8, b = 0.8, a = 1.0 },
  { id = "buildings",  visible = true, path = "geos/buildings.obj",  r = 0.8, g = 0.8, b = 0.8, a = 1.0 },
  { id = "forest",     visible = true, path = "geos/forest.obj",     r = 0.8, g = 0.8, b = 0.8, a = 1.0 },
}

-- Push the geometry.
cfdr_push(city, "GEO")

slice = {
    { id = "y",     preload_series = false,  visible = false, path = "sli" },
}

-- Add slices.
cfdr_push(slice, "SLI")
